<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BORRADO DE ALUMNOS</title>
    <script>
        function confirmarBorradoTodo(num) {
            return confirm("Vas a borrar TODOS los alumnos (" + num + " registros). ¿Estás seguro?");
        }

        function confirmarBorradoUno(nombre) {
            return confirm("¿Está seguro de que quieres borrar el alumno: " + nombre + "?");
        }
    </script>
</head>
<?php         
    include 'baseDeDatos.php' 
?>

<body>
    <h1>BORRADO DE ALUMNOS</h1>

    <?php 
    if (isset($_POST["fase"]) && $_POST["fase"] == "borrar" && isset($_POST["nombre"])) {

        if (trim($_POST["nombre"]) == "") {
            // Borrar todos los registros
            $cuenta = $idCone->query("SELECT COUNT(*) as total FROM ALUMNOS");
            $fila = $cuenta->fetch_assoc();
            $total = $fila["total"];

            ?>
            <form method="POST" action="borrarAlumno.php" onsubmit="return confirmarBorradoTodo(<?php echo $total; ?>);">
                <input type="hidden" name="fase" value="confirmarTodo">
                <input type="submit" value="Confirmar borrado total de <?php echo $total; ?> registros">
            </form>
            <?php

        } else {
            // Buscar un alumno
            $consulta = "SELECT * FROM ALUMNOS WHERE nombre = ?";
            $resultado = $idCone->prepare($consulta);
            $resultado->bind_param("s", $_POST["nombre"]);
            $resultado->execute();
            $datos = $resultado->get_result();

            if ($datos->num_rows > 0){
                $alumno = $datos->fetch_assoc();
                ?>
                <p><strong>Nombre:</strong> <?php echo $alumno["nombre"]; ?></p>
                <p><strong>Dirección:</strong> <?php echo $alumno["direccion"]; ?></p>
                <p><strong>Email:</strong> <?php echo $alumno["mail"]; ?></p>
                <p><strong>Teléfono:</strong> <?php echo $alumno["telefono"]; ?></p>

                <form method="POST" action="borrarAlumno.php" onsubmit="return confirmarBorradoUno('<?php echo $alumno["nombre"]; ?>');">
                    <input type="hidden" name="fase" value="confirmarUno">
                    <input type="hidden" name="nombre" value="<?php echo $alumno["nombre"]; ?>">
                    <input type="submit" value="Borrar este alumno">
                </form>
                <?php
            } else {
                ?><p style="color:red;">No se ha encontrado ningún alumno con ese nombre.</p>
                <p>
                    <a href="menu.php">Volver al menú principal</a>
                </p>
                <?php
            }
        }

    } elseif (isset($_POST["fase"]) && $_POST["fase"] == "confirmarUno" && isset($_POST["nombre"])) {
        // Confirmación del borrado de un alumno
        $delete = "DELETE FROM ALUMNOS WHERE nombre = ?";
        $resultado = $idCone->prepare($delete);
        $resultado->bind_param("s", $_POST["nombre"]);
        $resultado->execute();

        ?><p><?php echo "El alumno con el nombre ".$_POST["nombre"]." se ha borrado correctamente"; ?></p>

        <p>
            <a href="menu.php">Volver</a>
        </p>
        <?php

    } elseif (isset($_POST["fase"]) && $_POST["fase"] == "confirmarTodo") {
        // Confirmación del borrado total
        $borrado = $idCone->query("DELETE FROM ALUMNOS");
        ?><p>Se han borrado todos los registros de alumnos.</p>
        <p>
            <a href="menu.php">Volver al menú principal</a>
        </p>
        <?php

    } else {
        // Primera pantalla: pedir nombre
        ?>
        <form action="borrarAlumno.php" method="POST">
            <input type="hidden" name="fase" value="borrar">
            <label>Introduce el nombre del alumno a borrar (deja en blanco para borrar toda la tabla): <input name="nombre" type="text"></label><br>
            <input type="submit" value="Buscar / Borrar">
        </form>
        <?php
    }
    ?>

</body>
</html>
