<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MODIFICACIÓN DE ALUMNOS</title>
</head>
<?php         
    include 'baseDeDatos.php' 
?>

<body>
    <h1>MODIFICACIÓN DE ALUMNOS</h1>

    <?php 
    // Si ya se ha enviado el formulario de modificación (segunda fase)
    if (isset($_POST["fase"]) && $_POST["fase"] == "modificar" && isset($_POST["nombre"]) && trim($_POST["nombre"]) != "") {

        $update = "UPDATE ALUMNOS SET direccion = ?, mail = ?, telefono = ? WHERE nombre = ?";
        $resultado = $idCone->prepare($update);
        $resultado->bind_param("ssis", $_POST["direccion"], $_POST["email"], $_POST["telefono"], $_POST["nombre"]);

        if ($resultado->execute()){
            ?><p><?php echo "Has modificado ". $resultado->affected_rows." registro(s)"; ?></p> 
        <?php 
        }

    // Si se ha enviado el nombre para buscar al alumno (primera fase)
    } elseif (isset($_POST["fase"]) && $_POST["fase"] == "buscar" && isset($_POST["nombre"]) && trim($_POST["nombre"]) != "") {

        $consulta = "SELECT * FROM ALUMNOS WHERE nombre = ?";
        $resultado = $idCone->prepare($consulta);
        $resultado->bind_param("s", $_POST["nombre"]);
        $resultado->execute();
        $datos = $resultado->get_result();

        if ($datos->num_rows > 0){
            $alumno = $datos->fetch_assoc();
            ?>
            <form action="modificarAlumno.php" method="POST">
                <input type="hidden" name="fase" value="modificar">
                <label>Nombre (no modificable): 
                    <input name="nombre" type="text" value="<?php echo $alumno['nombre']; ?>" readonly>
                </label><br>
                <label>Dirección 
                    <input name="direccion" type="text" value="<?php echo $alumno['direccion']; ?>">
                </label><br>
                <label>E-mail 
                    <input name="email" type="text" value="<?php echo $alumno['mail']; ?>">
                </label><br>
                <label>Teléfono 
                    <input name="telefono" type="text" value="<?php echo $alumno['telefono']; ?>">
                </label><br>
                <input type="submit" value="Modificar">
            </form>

            <p>
                <a href="menu.php">Cancelar la modificación y volver al menú principal</a>
            </p>
            <?php
        } else {
            ?><p style="color:red;">No se ha encontrado ningún alumno con ese nombre.</p><?php
        }

    // Primera pantalla: pedimos el nombre del alumno a modificar
    } else {
        ?>
        <form action="modificarAlumno.php" method="POST">
            <input type="hidden" name="fase" value="buscar">
            <label>Introduce el nombre del alumno a modificar: 
                <input name="nombre" type="text">
            </label><br>
            <input type="submit" value="Buscar">
        </form>
        <p>
            <a href="menu.php">Volver al menú principal</a>
        </p>
        <?php
    }
    ?>

</body>
</html>
