package Coches;

public class Automovil {

	String marca;
	int modelo;
	double motor;
	TipoDeCombustible tipo_de_combustible;
	TipoDeAutomovil tipo_de_automovil;
	int numeroPuertas;
	int numeroAsientos;
	int maxVelocidad;
	Color color;
	int velocidadActual;
	
	public Automovil(String marca, int modelo, double motor,TipoDeCombustible tipo_de_combustible,
	TipoDeAutomovil tipo_de_automovil, int numeroPuertas, int numeroAsientos, int maxVelocidad, Color color, int velocidadActual) {
		this.marca=marca;
		this.modelo=modelo;
		this.motor=motor;
		this.tipo_de_combustible=tipo_de_combustible;
		this.tipo_de_automovil=tipo_de_automovil;
		this.numeroPuertas=numeroPuertas;
		this.numeroAsientos=numeroAsientos;
		this.maxVelocidad=maxVelocidad;
		this.color=color;
		this.velocidadActual=velocidadActual;
	}
	
	public String getMarca() {
		return marca;
	}
	
	public void setMarca(String marca) {
		this.marca=marca;
	}
	
	public int getModelo() {
		return modelo;
	}
	
	public void setModelo(int modelo) {
		this.modelo=modelo;
	}
	
	public double getMotor() {
		return motor;
	}
	
	public void setMotor(double motor) {
		this.motor=motor;
	}
	
	public TipoDeCombustible getTipoDeCombustible() {
		return tipo_de_combustible;
	}
	
	public void setTipoDeCombustible(TipoDeCombustible tipo_de_combustible){
		this.tipo_de_combustible=tipo_de_combustible;
	}
	
	public TipoDeAutomovil getTipoDeAutomovil() {
		return tipo_de_automovil;
	}
	
	
	public void setTipoDeAutomovil (TipoDeAutomovil tipo_de_automovil){
		this.tipo_de_automovil=tipo_de_automovil;
	}
	
	public int getNumeroPuertas() {
		return numeroPuertas;
	}
	
	public void setNumeroPuertas(int numeroPuertas) {
		this.numeroPuertas=numeroPuertas;
	}
	
	public int getNumeroAsientos() {
		return numeroAsientos;
	}
	
	public void setNumeroAsientos(int numeroAsientos) {
		this.numeroAsientos=numeroAsientos;
	}
	
	
	
	public String getMaxVelocidad() {
		return maxVelocidad+"km/h";
	}
	
	public void setMaxVelocidad(int maxVelocidad) {
		this.maxVelocidad=maxVelocidad;
	}
	
	public Color getColor() {
		return color;
	}
	
	public void setColor(Color color) {
		this.color=color;
	}
	
	public String getVelocidadActual() {
		return velocidadActual+"km/h";
	}
	
	public void setVelocidadActual(int velocidadActual) {
		this.velocidadActual=velocidadActual;
	}
	
	
	public void acelerar(int aceleracion) {
		if(aceleracion>=0 && (aceleracion+velocidadActual)<maxVelocidad) {
			this.velocidadActual=(aceleracion+velocidadActual);
			System.out.println("Ahora vas a "+this.getVelocidadActual());
			
		}else {
			System.out.println("No puedes acelerar tanto (o tan poco)");
		}
	}
	
	public void desacelerar(int desaceleracion) {
		if(desaceleracion<0 && (velocidadActual-desaceleracion)<0) {
			System.out.println("No puedes desacelerar tanto");
			
			
		}else {
			this.velocidadActual=(velocidadActual-desaceleracion);
			System.out.println("Ahora vas a "+this.getVelocidadActual());
		}
	}
	
	
	public void frenar() {
		this.velocidadActual=0;
		System.out.println("Has frenado, tu velocidad actual es de "+this.velocidadActual);
	}
	
	public void tiempoRestante(int distancia) {
		System.out.println("Llegaras a tu destino en "+(distancia/this.velocidadActual)+" horas");
	}
	
	public void mostrarInformacion() {
		System.out.println("Marca: "+marca+"\n"
				+ "Modelo: "+modelo+"\n"
						+ "Motor: "+motor+" litros\n"
								+ "Tipo de combustible: "+tipo_de_combustible+"\n"
										+ "Tipo de automovil: "+tipo_de_automovil+"\n"
												+ "Numero de puertas: "+numeroPuertas+"\n"
														+ "Cantidad de asientos: "+numeroAsientos+"\n"
																+ "Velocidad maxima: "+maxVelocidad+"\n"
																		+ "Color: "+color+"\n"
																				+ "Velocidad actual: "+this.getVelocidadActual());
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
}
