import model.dao.PersonasDAO;
import model.entities.Personas;
import model.motorsql.MotorPostgre;
import services.PeliculaAction;
import services.UsuarioAction;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;

@WebServlet(name = "Controller", urlPatterns = {"/Controller"})
public class Controller extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        processRequest(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        processRequest(req, resp);
    }

    protected void processRequest(
            HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
// ENDPOINTS DE EJEMPLOS PARA QUE VEÁIS LA ESTRUCTURA
        //http://localhost:8080/untitled/Controller?ACTION=PELICULA.FIND_ALL
        // http://localhost:8080/API_JAVA_MYSQL/Controller?ACTION=PELICULA.FILTER&FILTRO=DRAMA
//
        response.setContentType("text/plain;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*"); // Permitir acceso desde cualquier origen
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS"); // Permitir los métodos HTTP
        response.setHeader("Access-Control-Allow-Headers", "Content-Type, Authorization"); // Permitir ciertos encabezados
        response.setHeader("Access-Control-Max-Age", "3600"); // Cache de opciones preflight durante 1 hora

        PrintWriter out = response.getWriter();
        //out.print("ESTOY FUNCIONANDO");
        //MotorPostgre motorPostgre = new MotorPostgre();
        //motorPostgre.connect();
        /*ResultSet rs = motorPostgre.executeQuery("SELECT * FROM personas");
        try{
            rs.next();
            out.print(rs.getString(2));
        } catch (Exception e) {
            out.print(e.getMessage());
        }*/

        //¿Cómo obtengo un INSERT?




        String action = request.getParameter("ACCION");
        String[] arrayAction = action.split("\\.");
        out.print(Arrays.toString(arrayAction));
        //http://localhost:8080/API_JAVA_MYSQL/Controller
        // ?ACCION=PERSONAS&OPCION=INSERTAR&NOMBRE=PEPITO&APELLIDOS=MENGANITO
        PersonasDAO p = new PersonasDAO("POSTGRE");

        switch (arrayAction[0]) {
            case "PERSONAS":
                switch (request.getParameter("OPCION")){

                    case "INSERTAR":
                        //Prueba: http://localhost:8080/API_JAVA_MYSQL/Controller?ACCION=PERSONAS&OPCION=INSERTAR&NOMBRE=PEPITO&APELLIDOS=MENGANITO
                        out.println("INSERTANDO");
                        out.println("Insertadas un total de "+p.add(new Personas(0,request.getParameter("NOMBRE")
                                ,request.getParameter("APELLIDOS")))+ " filas");
                        break;
                    case "ACTUALIZAR":
                        //Prueba: http://localhost:8080/API_JAVA_MYSQL/Controller?ACCION=PERSONAS&OPCION=ACTUALIZAR&ID=4&NOMBRE=PEPITO2&APELLIDOS=MENGANITO3
                        out.println("ACTUALIZANDO");
                        out.println("Actualizando un total de "+p.update(new Personas(Integer.parseInt(request.getParameter("ID")),request.getParameter("NOMBRE")
                                ,request.getParameter("APELLIDOS")))+ " filas");
                        break;
                    case "ELIMINAR":
                        //Prueba: http://localhost:8080/API_JAVA_MYSQL/Controller?ACCION=PERSONAS&OPCION=ELIMINAR&ID=1
                        out.println("ELIMINANDO");
                        out.println("Eliminando un total de "+p.delete(Integer.parseInt(request.getParameter("ID")))+ " filas");
                        break;
                    case "CONSULTAR":
                        //Prueba: http://localhost:8080/API_JAVA_MYSQL/Controller?ACCION=PERSONAS&OPCION=CONSULTAR
                        out.println("CONSULTANDO");

                        ArrayList<Personas> personas = p.findAll(null);
                        for (int i = 0; i < personas.size(); i++) {
                            out.println(personas.get(i).getId()+" "+personas.get(i).getNombre()+" "+personas.get(i).getApellidos()+"\n");
                        }
                    case "CONSULTAR2":
                        //Prueba: http://localhost:8080/API_JAVA_MYSQL/Controller?ACCION=PERSONAS&OPCION=CONSULTAR2&APELLIDOS=Mart%C3%ADnez%20Garc%C3%ADa

                        out.println("CONSULTANDO V2");

                        ArrayList<Personas> personas2 = p.filtroApellidos(request.getParameter("APELLIDOS"));
                        for (int i = 0; i < personas2.size(); i++) {
                            out.println(personas2.get(i).getId()+" "+personas2.get(i).getNombre()+personas2.get(i).getApellidos()+"\n");
                        }
                }
                break;



    }
}
}
