package model.dao;

import model.entities.Personas;
import model.factory.DatabaseFactory;
import model.motorsql.MotorSQL;

import java.sql.ResultSet;
import java.util.ArrayList;

public class PersonasDAO implements DAO<Personas,Integer>{
    public final String SQL_ADD = "INSERT INTO personas (nombre,apellidos) VALUES ";
    public final String SQL_UPDATE = "UPDATE personas set ";
    public final String SQL_DELETE = "DELETE FROM personas WHERE id= ";
    public final String SQL_SELECT = "SELECT * FROM personas";
    public final String SQL_SELECT_CONDICION1 = "SELECT * FROM personas WHERE APELLIDOS = ";
    private MotorSQL motorSql;

    public PersonasDAO(String db) {
        motorSql = DatabaseFactory.getDatabase(db);
    }
    @Override
    public int add(Personas bean) {
        int resp = 0;
        try {
            motorSql.connect();

            String sql = SQL_ADD + "('"
                    + bean.getNombre() + "', '"
                    + bean.getApellidos() + "');";

            resp = motorSql.execute(sql);

        } catch (Exception e) {
            System.out.println(e);
        } finally {
            motorSql.disconnect();
        }
        if (resp > 0) {
            System.out.println("Película insertada con exito.");
        }
        return resp;
    }

    @Override
    public int delete(Integer e) {
        int resp = 0;
        try {
            motorSql.connect();

            String sql = SQL_DELETE + e;
            System.out.println(sql);
            resp = motorSql.execute(sql);

        } catch (Exception er) {
            er.printStackTrace();
        } finally {
            motorSql.disconnect();
        }
        if (resp > 0) {
            System.out.println("Película eliminada con exito.");
        }
        return resp;
    }

    @Override
    public int update(Personas bean) {
        int resp = 0;
        try {
            motorSql.connect();

            String sql = SQL_UPDATE + "NOMBRE= '"
                    + bean.getNombre() + "' , APELLIDOS= '"
                    + bean.getApellidos() + "' WHERE ID= "+bean.getId();
            System.out.println(sql);
            resp = motorSql.execute(sql);

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            motorSql.disconnect();
        }
        if (resp > 0) {
            System.out.println("Película insertada con exito.");
        }
        return resp;
    }

    @Override
    public ArrayList<Personas> findAll(Personas bean) {
        motorSql.connect();
        ArrayList<Personas> personas = new ArrayList<>();
        try{
            ResultSet rs = motorSql.executeQuery(SQL_SELECT);

            //¿Cómo recorro cada fila (Resultado de toda la consulta)?
            while(rs.next()){
                personas.add(new Personas(rs.getInt(1),rs.getString(2), rs.getString(3)));
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            motorSql.disconnect();
        }
        return personas;
    }
    public ArrayList<Personas> filtroApellidos(String apellido) {
        motorSql.connect();
        ArrayList<Personas> personas = new ArrayList<>();
        try{
            ResultSet rs = motorSql.executeQuery(SQL_SELECT_CONDICION1+"'"+apellido+"'");

            //¿Cómo recorro cada fila (Resultado de toda la consulta)?
            while(rs.next()){
                personas.add(new Personas(rs.getInt(1),rs.getString(2), rs.getString(3)));
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            motorSql.disconnect();
        }
        return personas;
    }
}
