package org.example;

import org.example.clases.Articulo;
import org.example.clases.Proveedor;
import org.example.clases.TicketVenta;
import org.example.dao.ArticuloDAO;
import org.example.dao.ProveedorDAO;
import org.example.dao.TicketDAO;

import java.sql.*;
import java.util.List;
import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        try {
            ArticuloDAO articuloDao = new ArticuloDAO();
            TicketDAO ticketDao = new TicketDAO();

            Scanner sc = new Scanner(System.in);
            int opcion;

            do {
                System.out.println("\n--- MENÚ TIENDA ---");
                System.out.println("1. Ver todas las ventas (tickets)");
                System.out.println("2. Ver ventas en un periodo");
                System.out.println("3. Ver todos los artículos");
                System.out.println("4. Insertar un nuevo artículo");
                System.out.println("5. Ver la lista de Proveedores");
                System.out.println("6. Salir");
                System.out.print("Selecciona opción: ");
                opcion = sc.nextInt();
                sc.nextLine();

                switch (opcion) {
                    case 1:
                        List<TicketVenta> tickets = ticketDao.listarTickets();
                        for (TicketVenta t : tickets) {
                            System.out.println(t.getIdTicket() + " | " + t.getFecha() + " | " +
                                    t.getUltimosDigitosTarjeta() + " | " + t.getModoPago());
                        }
                        break;

                    case 2:
                        System.out.print("Fecha desde (YYYY-MM-DD): ");
                        Date desde = Date.valueOf(sc.nextLine());
                        System.out.print("Fecha hasta (YYYY-MM-DD): ");
                        Date hasta = Date.valueOf(sc.nextLine());
                        List<TicketVenta> ticketsPeriodo = ticketDao.listarTicketsPorPeriodo(desde, hasta);
                        for (TicketVenta t : ticketsPeriodo) {
                            /*System.out.println(t.getIdTicket() + " | " + t.getFecha() + " | " +
                                    t.getUltimosDigitosTarjeta() + " | " + t.getModoPago());*/
                            System.out.println(t);
                        }
                        break;

                    case 3:
                        List<Articulo> articulos = articuloDao.listarArticulos();
                        for (Articulo a : articulos) {
                            /*System.out.println(a.getIdArticulo() + " | " + a.getNumReferencia() + " | " +
                                    a.getCantidad() + " | " + a.getNombre() + " | " + a.getDescripcion());*/
                            System.out.println(a);
                        }
                        for (int i = 0; i < articulos.size(); i++) {
                            Articulo a = articulos.get(i);
                        }
                        break;

                    case 4:
                        System.out.print("Número de referencia: ");
                        int numRef = sc.nextInt();
                        System.out.print("Cantidad: ");
                        int cant = sc.nextInt();
                        sc.nextLine();
                        System.out.print("Nombre: ");
                        String nombre = sc.nextLine();
                        System.out.print("Descripción: ");
                        String desc = sc.nextLine();
                        Articulo nuevo = new Articulo(numRef, cant, nombre, desc);
                        articuloDao.insertarArticulo(nuevo);
                        System.out.println("Artículo insertado correctamente.");
                        break;
                    case 5:

                        /*List<Proveedor> listarProveedores = ProveedorDAO.listarProveedores();
                        for (int i = 0; i < listarProveedores.size(); i++) {
                            System.out.println(listarProveedores.get(i));
                        }*/

                        ProveedorDAO.listarProveedores().forEach(p->{
                            System.out.println(p);
                        });
                        break;
                    case 6:
                        System.out.println("Saliendo...");
                        break;

                    default:
                        System.out.println("Opción no válida.");
                }

            } while (opcion != 5);

            Conexion.getConexion().close();
            sc.close();
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }
}
