package org.example.dao;

import org.example.Conexion;
import org.example.clases.Articulo;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;

public class ArticuloDAO {

    private Connection conexion;

    public ArticuloDAO(Connection conexion) {
        this.conexion = conexion;
    }
    public ArticuloDAO(){
        try {
            conexion = Conexion.getConexion();
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Articulo> listarArticulos() {
        List<Articulo> lista = new ArrayList<>();
        String sql = "SELECT ID_ARTICULO, NUM_REFERENCIA, CANTIDAD, NOMBRE, DESCRIPCION FROM ARTICULO";
        try (Statement stmt = conexion.createStatement();
             ResultSet rs = stmt.executeQuery(sql)) {
            while (rs.next()) { //Filas
                Articulo art = new Articulo(
                        rs.getInt("ID_ARTICULO"), //Columnas
                        rs.getInt("NUM_REFERENCIA"), //Columnas
                        rs.getInt("CANTIDAD"), //Columnas
                        rs.getString("NOMBRE"), //Columnas
                        rs.getString("DESCRIPCION") //Columnas
                );
                lista.add(art);
            }
        } catch (SQLException e) {
            System.out.println("Error al obtener artículos: " + e.getMessage());
        }
        return lista;
    }


    public void insertarArticulo(Articulo articulo) {
        try {
            int nuevoId = obtenerSiguienteId();
            String sql = "INSERT INTO ARTICULO (ID_ARTICULO, NUM_REFERENCIA, CANTIDAD, NOMBRE, DESCRIPCION) VALUES (?, ?, ?, ?, ?)";
            try (PreparedStatement ps = conexion.prepareStatement(sql)) {
                ps.setInt(1, nuevoId);
                ps.setInt(2, articulo.getNumReferencia());
                ps.setInt(3, articulo.getCantidad());
                ps.setString(4, articulo.getNombre());
                ps.setString(5, articulo.getDescripcion());
                ps.executeUpdate();
                System.out.println("Artículo insertado correctamente con ID: " + nuevoId);
            }
        } catch (SQLException e) {
            System.out.println("Error al insertar artículo: " + e.getMessage());
        }
    }




    private int obtenerSiguienteId() {
        String sql = "SELECT NVL(MAX(ID_ARTICULO), 0) + 1 AS NUEVO_ID FROM ARTICULO";
        try (Statement stmt = conexion.createStatement();
             ResultSet rs = stmt.executeQuery(sql)) {
            if (rs.next()) {
                return rs.getInt("NUEVO_ID");
            }
        } catch (SQLException e) {
            System.out.println("Error al obtener siguiente ID: " + e.getMessage());
        }
        return 1;
    }
}
