package org.example.dao;

import org.example.Conexion;
import org.example.clases.Articulo;
import org.example.clases.Proveedor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ProveedorDAO {

    public static List<Proveedor> listarProveedores() {
        List<Proveedor> lista = new ArrayList<>();
        String sql = "SELECT * FROM PROVEEDOR";
        try (Statement stmt = Conexion.getConexion().createStatement();
             ResultSet rs = stmt.executeQuery(sql)) {
            while (rs.next()) { //Filas
                Proveedor prov = new Proveedor(
                        rs.getInt("ID_PROVEEDOR"), //Columnas
                        rs.getString("CIF"), //Columnas
                        rs.getString("NOMBRE_PROVEEDOR"), //Columnas
                        rs.getString("DIRECCION_WEB"), //Columnas
                        rs.getInt("TELEFONO"), //Columnas
                        rs.getString("MUNICIPIO"), //Columnas
                        rs.getString("NOMBRE_CONTACTO"), //Columnas
                        rs.getString("DIRECCION") //Columnas

                );
                lista.add(prov);
            }
        } catch (SQLException e) {
            System.out.println("Error al obtener proveedor: " + e.getMessage());

        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return lista;
    }
}
