package org.example.dao;

import org.example.Conexion;
import org.example.clases.TicketVenta;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;

public class TicketDAO {
    private Connection conexion;

    public TicketDAO(Connection conexion) {
        this.conexion = conexion;
    }
    public TicketDAO(){
        try {
            this.conexion = Conexion.getConexion();
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }


    public List<TicketVenta> listarTickets() throws SQLException {
        List<TicketVenta> lista = new ArrayList<>();
        String sql = "SELECT ID_TICKET_VENTA, FECHA_TICKET, DIGITOS_ULT_TARJETA, MODO_PAGO FROM TICKET_VENTA";
        Statement stmt = conexion.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            lista.add(new TicketVenta(
                    rs.getInt("ID_TICKET_VENTA"),
                    rs.getDate("FECHA_TICKET"),
                    rs.getInt("DIGITOS_ULT_TARJETA"),
                    rs.getString("MODO_PAGO")
            ));
        }
        return lista;
    }

    public List<TicketVenta> listarTicketsPorPeriodo(Date desde, Date hasta) throws SQLException {
        List<TicketVenta> lista = new ArrayList<>();
        String sql = "SELECT ID_TICKET_VENTA, FECHA_TICKET, DIGITOS_ULT_TARJETA, MODO_PAGO " +
                "FROM TICKET_VENTA WHERE FECHA_TICKET BETWEEN ? AND ?";
        PreparedStatement ps = conexion.prepareStatement(sql);
        ps.setDate(1, desde);
        ps.setDate(2, hasta);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            lista.add(new TicketVenta(
                    rs.getInt("ID_TICKET_VENTA"),
                    rs.getDate("FECHA_TICKET"),
                    rs.getInt("DIGITOS_ULT_TARJETA"),
                    rs.getString("MODO_PAGO")
            ));
        }
        return lista;
    }
}
