package colmena;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author CARLOS
 */
public class AbejasObreras extends Thread{

    //Limpiadoras
    private Abejas abeja;

    public AbejasObreras(Abejas abeja) {
        this.abeja = abeja;
    }
    
    public void run(){
        try {
            limpiar(this.abeja);
            generarHalea(this.abeja);
        } catch (IOException ex) {
            Logger.getLogger(AbejasObreras.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    
    public void limpiar(Abejas abeja) throws IOException{
    
        
        int PUERTO = 5000;
        int respuesta = 0;
        String HOST = "127.0.0.1";
        Socket skCliente = null;
        String limpiar = "";
        Random r = new Random();
        int segundos;
        
        while(true){
        System.out.println("Abeja Obrera: Soy una " + this.abeja.getNombre() + " " + this.abeja.getId() + " y no tengo tarea voy a preguntar a la reina que limpio");        
        String presentacion = "Abeja Obrera: Mi querida reina soy: " + this.abeja.getNombre() + " " + this.abeja.getId();
           
        try {skCliente = new Socket(HOST, PUERTO); 
        } catch (IOException e) {
            System.out.println(e.getMessage());
        }
        
        if (skCliente != null)
        {   
            OutputStream aux = null;
            try {
                aux = skCliente.getOutputStream();
            } catch (IOException ex) {
                System.err.println("Error");
            }
            DataOutputStream flujo_salida = new DataOutputStream(aux);
            DataOutputStream flujo_salida2 = new DataOutputStream(aux);
            
            
            try {
                flujo_salida.writeUTF(presentacion);
                flujo_salida2.writeUTF(this.abeja.getNombre() + " " + this.abeja.getId());
            } catch (IOException ex) {
                System.err.println("Error");
            }
            
            InputStream aux2 = null;
            try {
                aux2 = skCliente.getInputStream();
            } catch (IOException ex) {
                System.err.println("Error");
            }
            DataInputStream flujo_entrada = new DataInputStream(aux2);
            try {
                limpiar = flujo_entrada.readUTF();
            } catch (IOException ex) {
                System.err.println("Error");
            }
            
            System.out.println("Abeja Obrera: La reina me ha dicho: " + limpiar);
            segundos = r.nextInt(8) + 3;
            calcularTiempo(segundos);
            System.out.println("HE TERMINADO!!!!!"); 
            
         
        }
        else
            System.out.println("Abeja Obrera: Soy la abeja no encuentro a la reina!!! Se habrá ido a echar un café");
        }
        
    }
    private void calcularTiempo(int segundos) {
        try {
            Thread.sleep(segundos * 1000);
        } catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }


    
    
  
    
    
    
    
   
    //Nodrizas
    public void generarHalea(Abejas abeja) throws IOException{
    
        
        int PUERTO = 5000;
        int respuesta = 0;
        String HOST = "127.0.0.1";
        Socket skCliente = null;
        String generarHalea = "";
        Random r = new Random();
        int segundos;
        
        while(true){
        System.out.println("Abeja Obrera: Soy una " + this.abeja.getNombre() + " " + this.abeja.getId() + " y no tengo tarea voy a preguntar a la reina que limpio");        
        String presentacion = "Abeja Obrera: Mi querida reina soy: " + this.abeja.getNombre() + " " + this.abeja.getId();
           
        try {skCliente = new Socket(HOST, PUERTO); 
        } catch (IOException e) {
            System.out.println(e.getMessage());
        }
        
        if (skCliente != null)
        {   
            OutputStream aux = null;
            try {
                aux = skCliente.getOutputStream();
            } catch (IOException ex) {
                System.err.println("Error");
            }
            DataOutputStream flujo_salida = new DataOutputStream(aux);
            DataOutputStream flujo_salida2 = new DataOutputStream(aux);
            
            
            try {
                flujo_salida.writeUTF(presentacion);
                flujo_salida2.writeUTF(this.abeja.getNombre() + " " + this.abeja.getId());
            } catch (IOException ex) {
                System.err.println("Error");
            }
            
            InputStream aux2 = null;
            try {
                aux2 = skCliente.getInputStream();
            } catch (IOException ex) {
                System.err.println("Error");
            }
            DataInputStream flujo_entrada = new DataInputStream(aux2);
            try {
                generarHalea = flujo_entrada.readUTF();
            } catch (IOException ex) {
                System.err.println("Error");
            }
            
            System.out.println("Abeja Obrera: La reina me ha dicho: " + generarHalea);
            segundos = r.nextInt(8) + 3;
            calcularTiempo(segundos);
            System.out.println("HE TERMINADO!!!!!"); 
            
         
        }
        else
            System.out.println("Abeja Obrera: Soy la abeja "
                    + this.abeja.getNombre() + "" + this.abeja.getId() + " y no encuentro a la reina!!! Se habrá ido a echar un café");
        }
        
    }
    //Recolectoras
    
}
    
