<?php
    require_once 'controladores/Controlador.php';
    require_once 'vistas/Vista.php';
    require_once 'modelos/MUsuarios.php';

    class CUsuarios extends Controlador{
        private $modelo;

        public function __construct(){
            $this->modelo = new MUsuarios();
        }

        public function getVistaUsuariosPrincipal($datos=array()){
            Vista::render('vistas/Usuarios/VUsuarioPrincipal.php');
        }
    
        public function getVistaListadoUsuarios($filtros=array()){
            //Buscar datos en BD
            $usuarios=$this->modelo->buscarUsuarios($filtros);
            //Visualizar datos obtenidos
            Vista::render('vistas/Usuarios/VUsuarioListado.php',array('usuarios'=>$usuarios));
        }

        
    } //Fin clase CUsuarios
?>