<?php
require_once 'controladores/Controlador.php';
require_once 'vistas/Vista.php';
require_once 'modelos/MProductos.php';

class CProductos extends Controlador
{
    private $modelo;

    public function __construct()
    {
        $this->modelo = new MProductos();
    }

    public function getVistaProductosPrincipal($datos = array())
    {
        Vista::render('vistas/Productos/VProductoPrincipal.php');
    }

    public function getVistaListadoProductos($filtros = array())
    {
        //Buscar datos en BD
        $productos = $this->modelo->buscarProductos($filtros);
        //Visualizar datos obtenidos
        Vista::render('vistas/Productos/VProductoListado.php', array('productos' => $productos));
    }
} //Fin clase CProductos
?>
