<?php
require_once 'controladores/Controlador.php';
require_once 'vistas/Vista.php';
require_once 'modelos/MUsuarios.php';

class CUsuarios extends Controlador
{
    private $modelo;

    public function __construct()
    {
        $this->modelo = new MUsuarios();
    }

    public function getVistaUsuariosPrincipal($datos = array())
    {
        Vista::render('vistas/Usuarios/VUsuarioPrincipal.php');
    }

    public function getVistaListadoUsuarios($filtros = array())
    {
        //Buscar datos en BD
        $usuarios = $this->modelo->buscarUsuarios($filtros);
        //Visualizar datos obtenidos
        Vista::render('vistas/Usuarios/VUsuarioListado.php', array('usuarios' => $usuarios));
    }
    public function insertarUsuario($datos)
    {
        if (isset($_POST["Confirmar"])) {
            if (empty($_POST["id"])) { //Se presupone que es un NUEVO REGISTRO, porque no tiene ID.
                $modeloUsuario = new MUsuarios();
                $modeloUsuario->insertarUsuario($_POST);
            }
        }
    }
        public function actualizarUsuario($datos)
    {
        if (isset($datos["Editar"])) {
            if (!empty($datos["id"])) { //Se presupone que es un NUEVO REGISTRO, porque no tiene ID.
                $modeloUsuario = new MUsuarios();
                $modeloUsuario->actualizarUsuario($datos);
            }
        }
    }
       public function eliminarUsuario($datos)
    {
        if (isset($_POST["Eliminar"])) {
            if (!empty($_POST["id"])) { //Se presupone que es un NUEVO REGISTRO, porque no tiene ID.
                $modeloUsuario = new MUsuarios();
                $modeloUsuario->eliminarUsuario($_POST);
            }
        }
    }
} //Fin clase CUsuarios
