import java.util.Arrays;
import java.util.Random;

class EstacionCarga {
    private final int[] tiemposCarga = {30, 45, 60};
    private final boolean[] modulosOcupados = new boolean[tiemposCarga.length];
    private final Random random = new Random();
    private final int FACTOR_SIMULACION = 100;

    //Constructor, rellena el array de boolean., con false
    public EstacionCarga() {
        Arrays.fill(modulosOcupados, false);
    }

    public int buscarHuecos() {
        for (int i = 0; i < modulosOcupados.length; i++) {
            boolean huecosOcupados = modulosOcupados[i];


            if (!huecosOcupados) {
                return i;
            }
        }
        return -1;
    }

    public synchronized int[] asignarModulo(int idRobot) {
        //Recorro el array, para buscar si hay algún hueco libre.
        int hueco;

        while ((hueco = buscarHuecos()) == -1) {
            System.out.println("Esperando hueco Robot " + idRobot);
            try {
                wait();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

        }
        //Si está libre, la ocupo.
        //Lo cambio a no libre == ocupado.
        modulosOcupados[hueco] = true;


        int tiempoEstimado = tiemposCarga[hueco];
        long tiempoRealSegundos = calcularTiempoReal(tiempoEstimado);

        return new int[]{hueco + 1, (int) tiempoRealSegundos, (int) tiempoRealSegundos * FACTOR_SIMULACION};
    }


    public synchronized void liberarModulo(int numModulo) {
        //Una vez termina un proceso
        modulosOcupados[numModulo - 1] = false;
        notifyAll();

    }

    private long calcularTiempoReal(int tiempoEstimado) {
        int factorRendimiento = random.nextInt(3) + 1; // 1 y 3
        int variacionMax = tiempoEstimado / 2; //La mitad
        int tiempoVariacion = random.nextInt(variacionMax + 1);

        long tiempoReal;

        if (factorRendimiento == 1) {
            tiempoReal = tiempoEstimado - tiempoVariacion;
        } else if (factorRendimiento == 3) {
            tiempoReal = tiempoEstimado + tiempoVariacion;
        } else {
            tiempoReal = tiempoEstimado;
        }

        return Math.max(1, tiempoReal);
    }
}