import java.util.concurrent.CountDownLatch;

class Robot extends Thread {
    private final int idRobot;
    private final EstacionCarga estacion;
    private final CountDownLatch contador;

    public Robot(int id, EstacionCarga estacion, CountDownLatch contador) {
        this.idRobot = id;
        this.estacion = estacion;
        this.contador = contador;
    }

    @Override
    public synchronized void run() {

        System.out.println("Robot " + idRobot + " llega a la estación de carga.");


        int[] resultadoAsignacion = null;
        //Se prueba para comrobar si puede cargarse...
        resultadoAsignacion = estacion.asignarModulo(idRobot);

        //En caso de no poder cargarse, lo indica y se queda a la espera. (A la espera de que se quede libre)


        int modulo = resultadoAsignacion[0];
        int tiempoSegundos = resultadoAsignacion[1];
        long tiempoMs = resultadoAsignacion[2]/10000;

        System.out.println("Robot " + idRobot + " comienza recarga en módulo " + modulo);

        try {
            Thread.sleep(tiempoMs);
        } catch (InterruptedException e) {
            System.out.println("Robot " + idRobot + " error no tiene modulos libres");
            estacion.liberarModulo(modulo);
            return;
        }

        System.out.println("Robot " + idRobot + " termina recarga en módulo " + modulo + " tras " + tiempoSegundos + " segundos");

        estacion.liberarModulo(modulo);


        System.out.println("Robot " + idRobot + " completamente operativo.");
        contador.countDown();

    }

}