package main;

import java.util.Scanner;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import objetos.alumno;

public class main {
	static EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory("default");
	static EntityManager entityManager = entityManagerFactory.createEntityManager();
	static EntityTransaction transaction = entityManager.getTransaction();

	static Scanner sc = new Scanner(System.in);

	public static void main(String[] args) {
		System.out.println("Hola. Introduce la opción que deseé.");
		System.out.println("1: Para consultar un registro");
		System.out.println("2: Actualizar un registro");
		System.out.println("3: Insertar un registro");
		System.out.println("4: Eliminar un registro");
		System.out.println("5: Ver todos los registros");
		int opcionElegida = sc.nextInt();
		switch (opcionElegida) {
		case 1:
			System.out.println("Introduzca el id del registro");
			alumno a1 = entityManager.find(alumno.class, sc.nextInt());
			if (a1 == null) { //En caso de que no lo encuentre.
				System.out.println("No se ha encontrado ningún alumno con ese ID.");
			} else {
				System.out.println(a1);
			}
			break;
		case 2:
			System.out.println("Introduzca el id del registro");
			alumno a2 = entityManager.find(alumno.class, sc.nextInt());
			System.out.println("Introduzca el nuevo nombre del alumno");
			sc.nextLine(); //Puesto que SCANNER omite el primer NEXTLINE después de NEXTINT
			a2.setNombre(sc.nextLine());
			entityManager.persist(a2);
			break;
		case 3:
			System.out.println("Introdzca el nombre del nuevo registro");
			alumno a3 = new alumno();
			sc.nextLine();
			a3.setNombre(sc.nextLine());
			System.out.println("Introduzca el apellido");
			a3.setApellido(sc.nextLine());
			System.out.println("Introduzca el curso");
			a3.setCurso(sc.nextLine());
			System.out.println("Introduzca la edad");
			a3.setEdad(sc.nextInt());

			System.out.println("Introduzca el número de asignaturas");
			a3.setNumeroAsignatura(sc.nextInt());
			entityManager.persist(a3);

			break;
		case 4:
			System.out.println("Introduzca el id del registro a eliminar");
			alumno a4 = entityManager.find(alumno.class, sc.nextInt());
			entityManager.remove(a4);
			System.out.println("Registro eliminado correctamente.");

			break;
		case 5:
			alumno a5 = new alumno();
			TypedQuery<alumno> alumnos = entityManager.createNamedQuery("alumno", alumno.class);
			for (alumno alumno : alumnos.getResultList()) {

				System.out.println(alumno);
			}
			break;
		default:
			System.out.println("La opción elegida no es correcta");
			break;
		}

		transaction.begin();
		/*
		 * //alumno a = new alumno(0,"Erika","Korkute","DAM",20,5);
		 * //entityManager.persist(a);
		 * 
		 * //Ejemplo de SELECT alumno a = entityManager.find(alumno.class,1);
		 * 
		 * //Ejemplo de UPDATE a.setNombre("Alejandro2"); entityManager.persist(a);
		 * 
		 * //Ejemplo de INSERT //alumno a1 = new alumno(0,"Erika","Korkute","DAM",20,5);
		 * //entityManager.persist(a1);
		 * 
		 * //Ejemplo de DELETE entityManager.remove(a);
		 */

		transaction.commit();

		// System.out.println(a.getNombre());
		// alumno a1 = new alumno(2,"Erika","Korkute","DAM",20,5);
		// entityManager.persist(a1);

	}

}
