package objetos;

import java.io.Serializable;
import java.util.ArrayList;

import javax.persistence.*;

@Entity
public class Cliente implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue
	private long id;
	private String nombre, apellido1, apellido2, comercioPrincipal, idEmpresa;
	private ArrayList<String> visitas;
	
	

	public Cliente(String nombre, String apellido1, String apellido2, String comercioPrincipal,
			String idEmpresa, ArrayList<String> visitas) {
		this.nombre = nombre;
		this.apellido1 = apellido1;
		this.apellido2 = apellido2;
		this.comercioPrincipal = comercioPrincipal;
		this.idEmpresa = idEmpresa;
		this.visitas = visitas;
	}



	@Override
	public String toString() {
		String toString = "Cliente [id=" + id + ", nombre=" + nombre + ", apellido1=" + apellido1 + ", apellido2=" + apellido2
				+ ", comercioPrincipal=" + comercioPrincipal + ", idEmpresa=" + idEmpresa + ", visitas=";
		
			for (String cliente : visitas) {
				toString+="visita: "+cliente+"\n";
			}
				toString+= "]";
				
				return toString;
	}



	public long getId() {
		return id;
	}



	public void setId(long id) {
		this.id = id;
	}



	public String getNombre() {
		return nombre;
	}



	public void setNombre(String nombre) {
		this.nombre = nombre;
	}



	public String getApellido1() {
		return apellido1;
	}



	public void setApellido1(String apellido1) {
		this.apellido1 = apellido1;
	}



	public String getApellido2() {
		return apellido2;
	}



	public void setApellido2(String apellido2) {
		this.apellido2 = apellido2;
	}



	public String getComercioPrincipal() {
		return comercioPrincipal;
	}



	public void setComercioPrincipal(String comercioPrincipal) {
		this.comercioPrincipal = comercioPrincipal;
	}



	public String getIdEmpresa() {
		return idEmpresa;
	}



	public void setIdEmpresa(String idEmpresa) {
		this.idEmpresa = idEmpresa;
	}



	public ArrayList<String> getVisitas() {
		return visitas;
	}



	public void setVisitas(ArrayList<String> visitas) {
		this.visitas = visitas;
	}



	public Cliente() {
	}
	
}
