package clases;

public class Biblioteca {

	private Libro[] libros; // Almacena el tipo de dato que especificas. [Declaración]

	public Biblioteca() {
		libros = new Libro[5]; // Se inicializa
	}

	public void agregarLibro(Libro libro) {
		System.out.println("Agregando Libro!!");
		// ¿Cómo sabemos si hay espacios disponibles?
		boolean insertarLibro = false;
		for (int i = 0; i < libros.length; i++) { // Recorrer el array
			Libro libroRecorrido = libros[i]; // Acceder a una posición del array
			// System.out.println("Posición: "+i+" → "+libroRecorrido);

			if (libroRecorrido == null && !insertarLibro) {
				libros[i] = libro; // Asignación dentro de un Array.
				insertarLibro = true;
				// System.out.println("→ Insertando libro en la posición "+i);
			}
		}
		if (insertarLibro) {
			System.out.println("Libro insertado correctamente\n");
		} else {
			System.out.println("Libro ¡¡NO!! insertado\n");

		}
	}

	public void mostrarLibros() {
		System.out.println("Mostrando Libros");
		for (int i = 0; i < libros.length; i++) {
			Libro libroRecorrido = libros[i];
			System.out.println(libroRecorrido);
		}
	}

	public void prestarLibro(String titulo) {
		// Busque en tu cajón (Array) de libros, si tienes un libro con el titulo pasado
		// por parámetros.

		for (int i = 0; i < libros.length; i++) { // Recorro todo los libros
			Libro libro = libros[i];

			if (libro.getTitulo().equals(titulo)) { // Si hay un libro que su titulo es igual al titulo que yo le he
													// pasado
				libro.setDisponible(false); // Marco como no disponible.
			}

		}

	}
	public void devolverLibro(String titulo) {
		// Busque en tu cajón (Array) de libros, si tienes un libro con el titulo pasado
		// por parámetros.

		for (int i = 0; i < libros.length; i++) { // Recorro todo los libros
			Libro libro = libros[i];

			if (libro.getTitulo().equals(titulo)) { // Si hay un libro que su titulo es igual al titulo que yo le he
													// pasado
				libro.setDisponible(true); // Marco como no disponible.
			}

		}

	}

}
