package Pokemon;

import Ataques.EstrategiaAtaque;

public abstract class Pokemon {
    protected String nombre;
    protected int nivel;
    protected int energia;
    public static final int  MAX_NIVEL = 100;
    protected EstrategiaAtaque estrategiaAtaque;

    public void setEstrategiaAtaque(EstrategiaAtaque estrategia) {
        this.estrategiaAtaque = estrategia;
    }


    public Pokemon(String nombre, int nivel, int energia) {
        this.nombre = nombre;
        this.nivel = nivel;
        this.energia = energia;
    }

    public String getNombre() {
        return nombre;
    }

    public abstract void atacar(Pokemon enemigo);
    public abstract void defender(int dano);
    public abstract Pokemon evolucionar();
    public abstract Pokemon involucionar();

    public final void subirNivel(){
        if (nivel < MAX_NIVEL){
            this.nivel++; //Aumeneto 1 nivel.
            System.out.println("El pokemon "+this.getClass().getName()+" ha subido de nivel");
        }else{
            System.out.println("El pokemon "+this.getClass().getName()+" no puede subir de nivel, puesto que ha llegado al límite.");
        }
    }

    @Override
    public String toString() {
        return "El pokemon "+this.getClass().getName()+" ("+this.nombre+") está en nivel "+this.nivel+" y tiene "+this.energia+" puntos de energía.";
    }
}
