package TiposPokemon;

import Ataques.AtaqueFuego;
import Ataques.EstrategiaAtaque;
import Pokemon.Pokemon;

public abstract class PokemonFuego  extends Pokemon implements EstrategiaAtaque {
    //implements →  Implementa una interfaz (Puede implementar un número indeterminado de interfaces)
    //extends →     Herencia de clases (Java no permite la herencia múltiple, es por eso, que el límite de herencias o (extends) es 1).

    String tipo;

    public PokemonFuego(String nombre, int nivel, int energia){ //¿Por qué no recogo el parámetro tipo?  //Respondida en clase.
        super(nombre, nivel, energia); //Uso claro de herencia con palabra reservada super()
        this.tipo = "fuego";
    }

    @Override
    public String toString() {
        return super.toString()+" Es de Tipo: "+this.tipo;
    }
    @Override
    public void atacar(Pokemon enemigo){
    new AtaqueFuego().atacar(enemigo);
    }
}
