package Criaturas;

import Pokemon.Pokemon;
import TiposPokemon.PokemonFuego;

public class Charmeleon extends PokemonFuego {
    public Charmeleon(String nombre, int nivel, int energia) {
        super(nombre, nivel, energia);
    }

    @Override
    public void atacar(Pokemon enemigo) {
        this.estrategiaAtaque.atacar(enemigo);
    }

    @Override
    public void defender(int dano) {
        this.energia-=dano;
        System.out.println(this.getNombre()+" recibe "+dano+" de daño.");
        System.out.println("Energía restante: "+this.energia);
    }

    @Override
    public Pokemon evolucionar() {
        return new Charizard(this.nombre,this.nivel,this.energia);
    }

    @Override
    public Pokemon involucionar() {
    //return ((Charmander)this); //Casting Dinámico.
        return new Charmander(this.nombre,this.nivel,this.energia);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}
