package Pokemon;

import Armas.Arma;
import Ataques.EstrategiaAtaque;
import TiposPokemon.PokemonFuego;

public abstract class Pokemon {
    protected String nombre;
    protected int nivel;
    protected int energia;
    public static final int  MAX_NIVEL = 100;
    protected EstrategiaAtaque estrategiaAtaque;
    protected Arma arma = null;

    public void setEstrategiaAtaque(EstrategiaAtaque estrategia) {
        this.estrategiaAtaque = estrategia;
    }

    public void equiparArma(Arma nuevaArma) throws Exception {
        //SOLO TIPO DE FUEGO
        if (this instanceof PokemonFuego){
            this.arma = nuevaArma;
        }else{
            throw new Exception("ERROR: El tipo del pokmemon no coincide con el tipo de ataque");
        }

    }
    public boolean usarArma(){
        return this.arma != null;
    }


    public Pokemon(String nombre, int nivel, int energia) {
        this.nombre = nombre;
        this.nivel = nivel;
        this.energia = energia;
    }

    public String getNombre() {
        return nombre;
    }

    public abstract void atacar(Pokemon enemigo);
    public abstract void defender(int dano);
    public abstract Pokemon evolucionar();
    public abstract Pokemon involucionar();

    public final void subirNivel(){
        if (nivel < MAX_NIVEL){
            this.nivel++; //Aumeneto 1 nivel.
            System.out.println("El pokemon "+this.getClass().getName()+" ha subido de nivel");
        }else{
            System.out.println("El pokemon "+this.getClass().getName()+" no puede subir de nivel, puesto que ha llegado al límite.");
        }
    }

    @Override
    public String toString() {
        if (usarArma()){
            return "El pokemon "+this.getClass().getName()+" ("+this.nombre+") está en nivel "+this.nivel+" y tiene "+this.energia+" puntos de energía además usa el arma "+this.arma;

        }else{
            return "El pokemon "+this.getClass().getName()+" ("+this.nombre+") está en nivel "+this.nivel+" y tiene "+this.energia+" puntos de energía.";

        }
    }
}
