package TiposPokemon;

import Ataques.AtaqueAgua;
import Ataques.EstrategiaAtaque;
import Pokemon.Pokemon;

public abstract class PokemonAgua extends Pokemon implements EstrategiaAtaque {
    //implements →  Implementa una interfaz (Puede implementar un número indeterminado de interfaces)
    //extends →     Herencia de clases (Java no permite la herencia múltiple, es por eso, que el límite de herencias o (extends) es 1).

    String tipo;

    public PokemonAgua(String nombre, int nivel, int energia){ //¿Por qué no recogo el parámetro tipo?  //Respondida en clase.
        super(nombre, nivel, energia); //Uso claro de herencia con palabra reservada super()
        this.tipo = "agua";
    }

    @Override
    public String toString() {
        return super.toString()+" Es de Tipo: "+this.tipo;
    }
    @Override
    public void atacar(Pokemon enemigo){
    new AtaqueAgua().atacar(enemigo);
    }
}
